Chapter 1.  Pascal Preliminaries

A Brief Review of Pascal

Form of a Pascal Program

     program<program-name> (INPUT,OUTPUT);
          {<declaration section>}
          procedure A;
          procedure B;
          begin
               {<executable-statements>}
               A;
               {<executable-statements>}
               B;
               {<executable-statements>}
          end.

Form of a Pascal Procedure or Subroutine

     procedure <procedure-name> [(<formal-parameter-list>)]
          {<local declaration section>}
          begin
               {<executable-statements>} i.e. procedure body
          end;

Form of a Call to a Procedure.

     <procedure-name>[<actual-parameter-list>]

Form of a Pascal function

     function <function-name> [(<formal-parameter-list>)]: result-type;
          {<local declaration section>}
          begin
          {<executable-statements>} i.e. function body
          end;

Specification Statements (Declaration Part)

     label
          999;

     const
          Max = 10;
          Pi = 3.1415926535;
          Small = 1e-20;

     type
          Subs = 1..Max;
          VECTOR = array[1..5] of real;
          MATRIX = array[1..5,1..5] of real;
          POINTER = array[Subs] of integer;
          STATUS = (Done,Iterating,Working);
          WORDS = string[80];


     var
          Column,I,J: integer;
          A0,B0,Max,X,Y: real;
          Flag: boolean;
          V,R: VECTOR;
          A,D: MATRIX;
          Row: POINTER;
          Name: string[80];
          Lines: WORDS;
          State: STATUS;

Assignment Statements

     X := A[1] + 3;
     Y := A*X*X + B*X + C;
     Flag := true;
     Name := 'Fran';

Arithmetic Operations

     +      Addition
     -      Subtraction
     *      Multiplication
     /      Division
     div    Integer Division
     mod    Remainder (Integer)

Relational Operators

     =      Equal to
     <>     Not equal to
     <      Less than
     >      Greater than
     <=     Less than or equal to
     >=     Greater than or equal to

Logical Operators

     not    Complement
     and    True if both operands are true
     or     True if either (or both) operands are true

Logical Constants

     true
     false

Remark Statement

     {This is a comment.}

Place-holder Statement (or label)

     100:


Unconditional Transfer

     goto 100;

     Warning. A GOTO statement must not leave the current block.

IF (Block) Control Statement

Performs the series of {<executable-statement>} following it or transfers control to an else, or end statement, depending on the value of the (<logical-expression>).

     if (<logical-expression>) then
          {<one executable-statements>};

     if (<logical-expression>) then
          begin
               {<one executable-statement>}
          end;

     if (<logical-expression>) then
          {<one executable-statement>}
     else
          {<one executable-statement>};


     if (<logical-expression>) then
          begin
               {<executable-statements>}
          end
     else
          begin
               {<executable-statements>}
          end;

     if (<logical-expression-#1>) then
          begin
               {<executable-statements>}
          end
     else 
          begin
               if (<logical-expression-#2>) then
                    begin
                         {<executable-statements>}
                    end
               else
                    begin
                         {<executable-statements>}
                    end;
          end;

Indexed Loop Control Statement

     Sum := 0;
     for  k := 0  to  100  do
          Sum := Sum + k;

     Sum := 0;
     for  k := 1000  downto  1  do
          Sum := Sum + 1.0/k;

     for  j := 1  to  5  do
          for  k := 1  to  5  do
               A[j,k] := 1.0/(j+k-1);

While Loop Structure
     The <logical-expression> is evaluated first.  If the logical expression is true, then the loop body will be executed.  The sequence is repeated as long as the expression remains true.  If the expression is false, then the loop body will be skipped, and execution will continue with the statement following  end;.

     while (<logical-expression>) do
          begin
               {<executable-statements>}
          end

Case Statement

     Case  FunType
          1: F := x;
          2: F := x*x;
     else
          F := x*x*x;
     end;

Input and Output

     readln(x,y);
     readln(A[i,j]);

     writeln;
     writeln('x = ',x,'     y = ',y);
     write  ('A(i,j) = ',A[i,j]:15:5);

Mathematical Functions

     cos(x)     cosine (radians)
     sin(x)     sine (radians)
     exp(x)     exponential  exp(x)
     arctan(x)  inverse tangent (radians)
     ln(x)      natural logarithm base  e
     sqrt(x)    square root
     sqr(x)     the square of a number
     abs(x)     absolute value
     int(x)     real valued greatest integer function
     trunc(x)   integer valued greatest integer function
     round(x)   the closest integer value

